NUMS="2 5 10 20 30 50 100 200 300 500 1000 2000 3000 5000 10000"


for num_stacks in $NUMS
do
    echo "Setting num_stacks to $num_stacks"
    sed -i 's/#define NUM_STACKS .*/#define NUM_STACKS '$num_stacks'/' sim/num_stacks.h

    echo "Compiling"
    scons -c -Q >$num_stacks-build-clean.log 2>&1
    /usr/bin/time -o $num_stacks-scons-time.txt scons -Q -j 3 -k >$num_stacks-build.log 2>&1

    echo "Checking output files"
    
    strip *.so
    ls -lah *.so > $num_stacks-stack-size.txt
    
    find lwip-HEAD freebsd5 linux-2.4 linux-2.6 openbsd3 -iname '*.parsed.c' |
        xargs wc -c > $num_stacks-file-sizes.txt
done
