/*
  Network Simulation Cradle
  Copyright (C) 2003-2005 Sam Jansen

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc., 59
  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
// lib/brlock.c
#include <linux/config.h>
#include <linux/sched.h>
#include <linux/brlock.h>
// mm/page_alloc.c
//#include <linux/config.h>
#include <linux/mm.h>
#include <linux/swap.h>
#include <linux/swapctl.h>
#include <linux/interrupt.h>
#include <linux/pagemap.h>
#include <linux/bootmem.h>
#include <linux/slab.h>
#include <linux/module.h>
// fs/fcntl.c
#include <linux/init.h>
//#include <linux/mm.h>
#include <linux/file.h>
#include <linux/dnotify.h>
#include <linux/smp_lock.h>
#include <linux/slab.h>
#include <linux/iobuf.h>
#include <linux/ptrace.h>
// kernel/sysctl.c
#include <linux/config.h>
#include <linux/slab.h>
#include <linux/sysctl.h>
#include <linux/swapctl.h>
#include <linux/proc_fs.h>
#include <linux/ctype.h>
#include <linux/utsname.h>
#include <linux/capability.h>
#include <linux/smp_lock.h>
#include <linux/init.h>
#include <linux/sysrq.h>
#include <linux/highuid.h>
#include <linux/swap.h>
// kernel/softirq.c
#include <linux/config.h>
#include <linux/mm.h>
#include <linux/kernel_stat.h>
#include <linux/interrupt.h>
#include <linux/smp_lock.h>
#include <linux/init.h>
#include <linux/tqueue.h>
// kernel/timer.c
#include <linux/config.h>
#include <linux/mm.h>
#include <linux/timex.h>
#include <linux/delay.h>
#include <linux/smp_lock.h>
#include <linux/interrupt.h>
#include <linux/kernel_stat.h>
// kernel/sys.c
#include <linux/notifier.h>

extern void nsc_debugf(const char *, ...);
extern void nsc_assert(int, const char *);
extern void *nsc_malloc(int);
extern void nsc_free(void *);
extern void *nsc_memcpy(void *to, const void *from, unsigned len);
extern void nsc_wakeup();

#define UNIMPLEMENTED_NOASSERT() /*nsc_debugf("Unimplemented " __FUNCTION__ \
        " called.\n");*/

// mm/slab.c
#define CACHE_NAMELEN	20	/* max name length for a slab cache */

struct kmem_cache_s {
/* 1) each alloc & free */
	/* full, partial first, then free */
	struct list_head	slabs_full;
	struct list_head	slabs_partial;
	struct list_head	slabs_free;
	unsigned int		objsize;
	unsigned int	 	flags;	/* constant flags */
	unsigned int		num;	/* # of objs per slab */
	spinlock_t		spinlock;
#ifdef CONFIG_SMP
	unsigned int		batchcount;
#endif

/* 2) slab additions /removals */
	/* order of pgs per slab (2^n) */
	unsigned int		gfporder;

	/* force GFP flags, e.g. GFP_DMA */
	unsigned int		gfpflags;

	size_t			colour;		/* cache colouring range */
	unsigned int		colour_off;	/* colour offset */
	unsigned int		colour_next;	/* cache colouring */
	kmem_cache_t		*slabp_cache;
	unsigned int		growing;
	unsigned int		dflags;		/* dynamic flags */

	/* constructor func */
	void (*ctor)(void *, kmem_cache_t *, unsigned long);

	/* de-constructor func */
	void (*dtor)(void *, kmem_cache_t *, unsigned long);

	unsigned long		failures;

/* 3) cache creation/removal */
	char			name[CACHE_NAMELEN];
	struct list_head	next;
#ifdef CONFIG_SMP
/* 4) per-cpu data */
	//cpucache_t		*cpudata[NR_CPUS];
#endif
#if STATS
	unsigned long		num_active;
	unsigned long		num_allocations;
	unsigned long		high_mark;
	unsigned long		grown;
	unsigned long		reaped;
	unsigned long 		errors;
#ifdef CONFIG_SMP
	atomic_t		allochit;
	atomic_t		allocmiss;
	atomic_t		freehit;
	atomic_t		freemiss;
#endif
#endif
};


kmem_cache_t *
kmem_cache_create (const char *name, size_t size, size_t offset,
	unsigned long flags, void (*ctor)(void*, kmem_cache_t *, unsigned long),
	void (*dtor)(void*, kmem_cache_t *, unsigned long))
{
    kmem_cache_t *cache;
    
    UNIMPLEMENTED_NOASSERT();

    cache = nsc_malloc(sizeof(kmem_cache_t));
    nsc_assert(cache != NULL, "cache");

    cache->objsize = size;
    cache->ctor = ctor;
    cache->dtor = dtor;
    cache->flags = flags;
    strcpy(cache->name, name);
    
    return cache;
}

void * kmem_cache_alloc (kmem_cache_t *cachep, int flags)
{
    void *o;
    
    UNIMPLEMENTED_NOASSERT();
    o = nsc_malloc(cachep->objsize);
    if(cachep->ctor)
        (cachep->ctor)(o, cachep, SLAB_CTOR_CONSTRUCTOR);
    return o;
}

void kmem_cache_free (kmem_cache_t *cachep, void *objp)
{
    UNIMPLEMENTED_NOASSERT();
    if(cachep->dtor)
        (cachep->dtor)(objp, cachep, 0);
    nsc_free(objp);
}

void * kmalloc (size_t size, int flags)
{
    UNIMPLEMENTED_NOASSERT();
    // XXX: are flags important here?
    return nsc_malloc(size);
}

void kfree (const void *objp)
{
    UNIMPLEMENTED_NOASSERT();
    nsc_free((void *)objp);
}


// fs/super.c
int register_filesystem(struct file_system_type * fs)
{
    UNIMPLEMENTED_NOASSERT();
    return 0;
}

// fs/super.c
struct vfsmount *kern_mount(struct file_system_type *type)
{
    struct vfsmount *v;
    
    UNIMPLEMENTED_NOASSERT();
    v = nsc_malloc(sizeof(struct vfsmount)); // XXX: leak
    v->mnt_sb = (struct super_block *)malloc(sizeof(struct super_block));

    return v;
}

// fs/inode.c    
struct inode * new_inode(struct super_block *sb)
{
    UNIMPLEMENTED_NOASSERT();
    return nsc_malloc(sizeof(struct inode)); // XXX
}

void __wake_up(wait_queue_head_t *q, unsigned int mode, int nr)
{
    UNIMPLEMENTED_NOASSERT();
    nsc_wakeup();
}

int notifier_chain_register(struct notifier_block **list, struct notifier_block *n)
{
    UNIMPLEMENTED_NOASSERT();
    // XXX: I think we might need this
    while(*list)
    {
        if(n->priority > (*list)->priority)
            break;
        list= &((*list)->next);
    }
    n->next = *list;
    *list=n;

    return 0L;
}


#include <linux/init.h>
void __init do_initcalls(void)
{
    initcall_t *call;

    call = &__initcall_start;
    do {
        (*call)();
        call++;
    } while (call < &__initcall_end);

    /* Make sure there is no pending stuff from the initcall sequence */
    //flush_scheduled_tasks();
}

// fs/proc/generic.c

void __br_write_lock (enum brlock_indices idx)
{
    //UNIMPLEMENTED_NOASSERT();
}

void __br_write_unlock (enum brlock_indices idx)
{
    //UNIMPLEMENTED_NOASSERT();
}

// drivers/char/random.c
void get_random_bytes(void *buf, int nbytes)
{
    UNIMPLEMENTED_NOASSERT();
    memset(buf, 1, nbytes);
}

__u32 secure_tcp_sequence_number(__u32 saddr, __u32 daddr,
				 __u16 sport, __u16 dport)
{  
    UNIMPLEMENTED_NOASSERT();
    return 0;
}

unsigned int csum_partial(const unsigned char * buff, int len, unsigned int sum)
{
    UNIMPLEMENTED_NOASSERT();
    return 0;
}

void add_wait_queue(wait_queue_head_t *q, wait_queue_t * wait)
{
    UNIMPLEMENTED_NOASSERT();
    __add_wait_queue(q, wait);
}

void add_wait_queue_exclusive(wait_queue_head_t *q, wait_queue_t * wait)
{
    UNIMPLEMENTED_NOASSERT();
    __add_wait_queue(q, wait);
}

signed long schedule_timeout(signed long timeout)
{
    UNIMPLEMENTED_NOASSERT();
    return 0;
}

void remove_wait_queue(wait_queue_head_t *q, wait_queue_t * wait)
{
    UNIMPLEMENTED_NOASSERT();
    __remove_wait_queue(q, wait);
}


// arch/i386/lib/mmx.c
void *_mmx_memcpy(void *to, const void *from, unsigned len)
{
    return nsc_memcpy(to, from, len);
}

unsigned long __get_free_pages(unsigned int gfp_mask, unsigned int order)
{
    UNIMPLEMENTED_NOASSERT();
    nsc_debugf("__get_free_pages: order=%u\n", order);

    // XXX: this cuts down on wasted memory. Everything still works, just
    // doesn't use quite as much memory.
    //
    // Note that if this is set to 2, the machine is assumed to have very
    // little memory and the TCP buffers will be smaller than you'll find on
    // say, an emulation machine.
    if(order > 3) return NULL;

    return (unsigned long)nsc_malloc( PAGE_SIZE * (1UL << order) );
}

//
void si_meminfo(struct sysinfo *val)
{
    UNIMPLEMENTED_NOASSERT();
    memset(val, 0, sizeof(*val));
}


// drivers/net/setup.c 
void __init net_device_init(void)
{
    UNIMPLEMENTED_NOASSERT();
}

// kernel/sys.c
int notifier_call_chain(struct notifier_block **n, unsigned long val, void *v)
{
    // This function definitely needs to be implemented. This is the normal
    // kernel version.
    int ret=NOTIFY_DONE;
    struct notifier_block *nb = *n;

    while(nb)
    {
            ret=nb->notifier_call(nb,val,v);
            if(ret&NOTIFY_STOP_MASK)
            {
                    return ret;
            }
            nb=nb->next;
    }
    return ret;
}

// kernel/kmod.c  
void dev_probe_lock(void)
{
    UNIMPLEMENTED_NOASSERT();
}

void dev_probe_unlock(void)
{
    UNIMPLEMENTED_NOASSERT();
}

int __down_failed_trylock(void)
{
    UNIMPLEMENTED_NOASSERT();
    return 0;
}

void __down_failed(void)
{
    UNIMPLEMENTED_NOASSERT();
}

// kernel/module.c
int try_inc_mod_count(struct module *mod)
{
    UNIMPLEMENTED_NOASSERT();
    return 1; // 0 says module is not present
}

// arch/i386/kernel/time.c
extern nsc_gettime(unsigned int *, unsigned int *);
void do_gettimeofday(struct timeval *tv)
{
    unsigned int sec, usec;
    nsc_gettime(&sec, &usec);
    tv->tv_sec = sec;
    tv->tv_usec = usec;

    UNIMPLEMENTED_NOASSERT();
}

long kernel_thread(int (*fn)(void *), void * arg, unsigned long flags)
{
    UNIMPLEMENTED_NOASSERT();
    return 0;
}

void yield(void)
{
    UNIMPLEMENTED_NOASSERT();
}

//
unsigned int  csum_partial_copy_generic(const char *src, char *dst, int len, 
        int sum, int *src_err_ptr, int *dst_err_ptr)
{
    UNIMPLEMENTED_NOASSERT();
    memcpy(dst, src, len);
    return 0;
}

// fs/inode.c
void iput(struct inode *inode)
{
    kfree(inode);
    //UNIMPLEMENTED_NOASSERT();
}

unsigned long __generic_copy_to_user(void *to, const void *from, 
        unsigned long n)
{
    UNIMPLEMENTED_NOASSERT();
    memcpy(to, from, n);
    return 0;
}

//
struct proc_dir_entry *create_proc_entry(const char *name, mode_t mode,
        struct proc_dir_entry *parent)
{
    struct proc_dir_entry *pde = kmalloc(sizeof(struct proc_dir_entry), 0);

    memset(pde, 0, sizeof(*pde));
    
    pde->name = strdup(name);
    pde->mode = mode;

    if(parent) {
        pde->next = parent->subdir;
        parent->subdir = pde;
        pde->parent = parent;
    }
    
    return pde;
}

int proc_match(int len, const char *name,struct proc_dir_entry * de)
{
    UNIMPLEMENTED_NOASSERT();
    if (!de || !de->low_ino)
            return 0;
    if (de->namelen != len)
            return 0;
    return !memcmp(name, de->name, len);
}

void remove_proc_entry(const char *name, struct proc_dir_entry *parent)
{
    UNIMPLEMENTED_NOASSERT();
}

struct proc_dir_entry *proc_mkdir(const char *name, struct proc_dir_entry *parent)
{
    struct proc_dir_entry *pde = kmalloc(sizeof(struct proc_dir_entry), 0);

    memset(pde, 0, sizeof(*pde));
    
    pde->name = name;
    if(parent) {
        pde->next = parent->subdir;
        parent->subdir = pde;
    } 

    return pde;
}

int __get_user_4(void)
{
    UNIMPLEMENTED_NOASSERT();
    return 0;
}


int in_egroup_p(gid_t grp)
{
    UNIMPLEMENTED_NOASSERT();
    return 1;
}

// Used to send SIGPIPE and so on. Ignore for now.
int
send_sig(int sig, struct task_struct *p, int priv)
{
    UNIMPLEMENTED_NOASSERT();
    return 0;
}

void init_irq_proc (void)
{
    UNIMPLEMENTED_NOASSERT();
}

void __up_wakeup(void)
{
    UNIMPLEMENTED_NOASSERT();
}


// fs/open.c
int get_unused_fd(void)
{
    UNIMPLEMENTED_NOASSERT();
    return 0;
}

// fs/file_table.c
struct file * get_empty_filp(void)
{
    struct file *f;
    
    UNIMPLEMENTED_NOASSERT();

    f = (struct file *)malloc(sizeof(struct file));
    memset(f, 0, sizeof(struct file));
    
    return f;
}

// fs/dcache.c
struct dentry * d_alloc(struct dentry * parent, const struct qstr *name)
{
    UNIMPLEMENTED_NOASSERT();
    return (struct dentry *)malloc(sizeof(struct dentry));
}

// fs/file_table.c 
void put_filp(struct file *file)
{
    UNIMPLEMENTED_NOASSERT();
}

void d_instantiate(struct dentry *entry, struct inode * inode)
{
    UNIMPLEMENTED_NOASSERT();
}

void d_rehash(struct dentry * entry)
{
    UNIMPLEMENTED_NOASSERT();
}

// fs/open.c
void fd_install(unsigned int fd, struct file * file)
{
    UNIMPLEMENTED_NOASSERT();
}

