/*
  Network Simulation Cradle
  Copyright (C) 2003-2005 Sam Jansen

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc., 59
  Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/* $Id$ */
/* Like unimplemented.c, but has functions in the "old" C-style. */
#include <sys/param.h>
//#include <sys/systm.h>
#include <sys/mac.h>
#include <sys/mbuf.h>
#include <sys/malloc.h>
#include <sys/domain.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/kernel.h>
#include <sys/syslog.h>
#include <sys/sysctl.h>
#include <sys/bus.h>
#include <sys/interrupt.h>
#include <sys/random.h>
#include <sys/event.h>
#include <sys/ucred.h>

#include <machine/stdarg.h>

#include <vm/vm.h>
#include <vm/vm_object.h>
#include <vm/vm_page.h>
#include <vm/vm_param.h>
#include <vm/vm_map.h>
#include <vm/vm_kern.h>
#include <vm/vm_extern.h>
#include <vm/uma.h>
#include <vm/uma_int.h>
#include <vm/uma_dbg.h>

#include <sys/resourcevar.h>
#include <sys/limits.h>

//#include <assert.h>
//#include <stdio.h>

#include "support/support.h"
#include "num_stacks.h"



vm_offset_t
kmem_malloc(map, size, flags)
        vm_map_t map;
        vm_size_t size;
        int flags;
{
	vm_offset_t ptr;
	UNIMPLEMENED_NOASSERT();

	ptr = (vm_offset_t)malloc(size, 0, flags);

	return ptr;
}


/*
 * Make all processes sleeping on the specified identifier runnable.
 */
void
wakeup(ident)
/* [<][>][^][v][top][bottom][index][help] */
        register void *ident;
{
    nsc_wakeup(ident);
}

/*
 * Make a process sleeping on the specified identifier runnable.
 * May wake more than one process if a target process is currently
 * swapped out.
 */
void
wakeup_one(ident)
/* [<][>][^][v][top][bottom][index][help] */
        register void *ident;
{
    //assert(0 && "This function is intentionally unimplemented.");
    nsc_wakeup(ident);
}


/*
 * Compute number of ticks in the specified amount of time.
 */
int
tvtohz(tv)
/* [<][>][^][v][top][bottom][index][help] */
        struct timeval *tv;
{
	register unsigned long ticks;
	register long sec, usec;

	/*
	 * If the number of usecs in the whole seconds part of the time
	 * difference fits in a long, then the total number of usecs will
	 * fit in an unsigned long.  Compute the total and convert it to
	 * ticks, rounding up and adding 1 to allow for the current tick
	 * to expire.  Rounding also depends on unsigned long arithmetic
	 * to avoid overflow.
	 *
	 * Otherwise, if the number of ticks in the whole seconds part of
	 * the time difference fits in a long, then convert the parts to
	 * ticks separately and add, using similar rounding methods and
	 * overflow avoidance.  This method would work in the previous
	 * case but it is slightly slower and assumes that hz is integral.
	 *
	 * Otherwise, round the time difference down to the maximum
	 * representable value.
	 *
	 * If ints have 32 bits, then the maximum value for any timeout in
	 * 10ms ticks is 248 days.
	 */
	sec = tv->tv_sec;
	usec = tv->tv_usec;
	if (usec < 0) {
		sec--;
		usec += 1000000;
	}
	if (sec < 0) {
#ifdef DIAGNOSTIC
		if (usec > 0) {
			sec++;
			usec -= 1000000;
		}
		printf("tvotohz: negative time difference %ld sec %ld usec\n",
		       sec, usec);
#endif
		ticks = 1;
	} else if (sec <= LONG_MAX / 1000000)
		ticks = (sec * 1000000 + (unsigned long)usec + (tick - 1))
			/ tick + 1;
	else if (sec <= LONG_MAX / hz)
		ticks = sec * hz
			+ ((unsigned long)usec + (tick - 1)) / tick + 1;
	else
		ticks = LONG_MAX;
	if (ticks > INT_MAX)
		ticks = INT_MAX;
	return ((int)ticks);

}

/*
 * Do a wakeup when a selectable event occurs.
 */
void
selwakeup(sip)
/* [<][>][^][v][top][bottom][index][help] */
        struct selinfo *sip;
{
    assert(0 && "This function is intentionally unimplemented.");
	UNIMPLEMENED_NOASSERT();
}

/* Wake up a selecting thread, and set its priority. */
void
selwakeuppri(sip, pri)
    struct selinfo *sip;
    int pri;
{
	UNIMPLEMENED_NOASSERT();
    assert(0 && "This function is intentionally unimplemented.");
}


/*ARGSUSED*/
int
seltrue(dev, events, td)
/* [<][>][^][v][top][bottom][index][help] */
        dev_t dev;
        int events;
        struct thread *td;
{
    assert(0 && "This function is intentionally unimplemented.");
    return (int)NULL;
}

/*
 * Record a select request.
 */
void
selrecord(selector, sip)
/* [<][>][^][v][top][bottom][index][help] */
        struct thread *selector;
        struct selinfo *sip;
{
    assert(0 && "This function is intentionally unimplemented.");
}

/*
 * Send a signal to a process group.  If checktty is 1,
 * limit to members which have a controlling terminal.
 */
void
pgsignal(pgrp, sig, checkctty)
/* [<][>][^][v][top][bottom][index][help] */
        struct pgrp *pgrp;
        int sig, checkctty;
{
    assert(0 && "This function is intentionally unimplemented.");
}

/*
 * Send a SIGIO or SIGURG signal to a process or process group using
 * stored credentials rather than those of the current process.
 */
void
pgsigio(sigiop, sig, checkctty)
/* [<][>][^][v][top][bottom][index][help] */
        struct sigio **sigiop;
        int sig, checkctty;
{
    assert(0 && "This function is intentionally unimplemented.");
}


void
malloc_uninit(data)
/* [<][>][^][v][top][bottom][index][help] */
        void *data;
{
 //   assert(0 && "This function is intentionally unimplemented.");
}

void
malloc_init(data)
/* [<][>][^][v][top][bottom][index][help] */
        void *data;
{
//    assert(0 && "This function is intentionally unimplemented.");
}

int
l_nowrite(tp, uio, flag)
/* [<][>][^][v][top][bottom][index][help] */
        struct tty *tp;
        struct uio *uio;
        int flag;
{
    assert(0 && "This function is intentionally unimplemented.");
    return (int)NULL;
}

int
l_noread(tp, uio, flag)
/* [<][>][^][v][top][bottom][index][help] */
        struct tty *tp;
        struct uio *uio;
        int flag;
{
    assert(0 && "This function is intentionally unimplemented.");
    return (int)NULL;
}

/*
 * ldisc_register: Register a line discipline.
 *
 * discipline: Index for discipline to load, or LDISC_LOAD for us to choose.
 * linesw_p:   Pointer to linesw_p.
 *
 * Returns: Index used or -1 on failure.
 */
int
ldisc_register(discipline, linesw_p)
/* [<][>][^][v][top][bottom][index][help] */
        int discipline;
        struct linesw *linesw_p;
{
    //assert(0 && "This function is intentionally unimplemented.");
	UNIMPLEMENED_NOASSERT();
    return (int)-1;
}

/*
 * ldisc_deregister: Deregister a line discipline obtained with
 * ldisc_register.
 *
 * discipline: Index for discipline to unload.
 */
void
ldisc_deregister(discipline)
/* [<][>][^][v][top][bottom][index][help] */
        int discipline;
{
    assert(0 && "This function is intentionally unimplemented.");
}

/*
 *      kmem_suballoc:
 *
 *      Allocates a map to manage a subrange
 *      of the kernel virtual address space.
 *
 *      Arguments are as follows:
 *
 *      parent          Map to take range from
 *      min, max        Returned endpoints of map
 *      size            Size of range to find
 */
vm_map_t
kmem_suballoc(parent, min, max, size)
/* [<][>][^][v][top][bottom][index][help] */
        vm_map_t parent;
        vm_offset_t *min, *max;
        vm_size_t size;
{
    assert(0 && "This function is intentionally unimplemented.");
    return (vm_map_t)NULL;
}

/*
 *      kmem_malloc:
 *
 *      Allocate wired-down memory in the kernel's address map for the higher
 *      level kernel memory allocator (kern/kern_malloc.c).  We cannot use
 *      kmem_alloc() because we may need to allocate memory at interrupt
 *      level where we cannot block (canwait == FALSE).
 *
 *      This routine has its own private kernel submap (kmem_map) and object
 *      (kmem_object).  This, combined with the fact that only malloc uses
 *      this routine, ensures that we will never block in map or object waits.
 *
 *      Note that this still only works in a uni-processor environment and
 *      when called at splhigh().
 *
 *      We don't worry about expanding the map (adding entries) since entries
 *      for wired maps are statically allocated.
 *
 *      NOTE:  This routine is not supposed to block if M_NOWAIT is set, but
 *      I have not verified that it actually does not block.
 *
 *      `map' is ONLY allowed to be kmem_map or one of the mbuf submaps to
 *      which we never free.
 */
/*vm_offset_t
kmem_malloc(map, size, flags)
        vm_map_t map;
        vm_size_t size;
        int flags;
{
    assert(0 && "This function is intentionally unimplemented.");
    return (vm_offset_t)NULL;
}*/

/*
 * General routine to allocate a hash table.
 */
/* Taken from kern/kern_subr.c */
void *
hashinit(elements, type, hashmask)
/* [<][>][^][v][top][bottom][index][help] */
        int elements;
        struct malloc_type *type;
        u_long *hashmask;
{
    long hashsize;
	LIST_HEAD(generic, generic) *hashtbl;
	int i;

	if (elements <= 0)
		panic("hashinit: bad elements");
	for (hashsize = 1; hashsize <= elements; hashsize <<= 1)
		continue;
	hashsize >>= 1;
	hashtbl = malloc((u_long)hashsize * sizeof(*hashtbl), type, M_WAITOK);
	for (i = 0; i < hashsize; i++)
		LIST_INIT(&hashtbl[i]);
	*hashmask = hashsize - 1;
	return (hashtbl);
}

/*
 * If sigio is on the list associated with a process or process group,
 * disable signalling from the device, remove sigio from the list and
 * free sigio.
 */
void
funsetown(sigiop)
/* [<][>][^][v][top][bottom][index][help] */
        struct sigio **sigiop;
{
	UNIMPLEMENED_NOASSERT();
    //assert(0 && "This function is intentionally unimplemented.");
}

/*
 * This is common code for FIOSETOWN ioctl called by fcntl(fd, F_SETOWN, arg).
 *
 * After permission checking, add a sigio structure to the sigio list for
 * the process or process group.
 */
int
fsetown(pgid, sigiop)
/* [<][>][^][v][top][bottom][index][help] */
        pid_t pgid;
        struct sigio **sigiop;
{
    assert(0 && "This function is intentionally unimplemented.");
    return (int)NULL;
}

/*
 * This is common code for FIOGETOWN ioctl called by fcntl(fd, F_GETOWN, arg).
 */
pid_t
fgetown(sigiop)
/* [<][>][^][v][top][bottom][index][help] */
        struct sigio **sigiop;
{
    assert(0 && "This function is intentionally unimplemented.");
    return (pid_t)NULL;
}

